# Bridge edge in a graph
## Medium
<div class="problems_problem_content__Xm_eO"><p><span style="font-size:18px">Given a&nbsp;Graph of V vertices and E edges and another edge(c -&nbsp;d), the task is to find if the given edge is a Bridge<strong>.</strong>&nbsp;i.e., removing the edge disconnects the graph.</span></p>

<p>&nbsp;</p>

<p><span style="font-size:18px"><strong>Example 1:</strong></span></p>

<pre><span style="font-size:18px"><strong>Input:</strong></span>
<img alt="" src="data:image/png;base64,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">
<span style="font-size:18px"><strong>c</strong> = 1, <strong>d</strong> = 2</span>
<span style="font-size:18px"><strong>Output:</strong>
1
<strong>Explanation</strong>:</span>
<span style="font-size:18px">From the graph, we can clearly see that
blocking the edge 1-2 will result in 
disconnection of the graph. So, it is 
a Bridge<strong> </strong>and thus the Output 1.</span>

</pre>

<p><span style="font-size:18px"><strong>Example 2:</strong></span></p>

<pre><span style="font-size:18px"><strong>Input:</strong></span>
<img alt="" src="data:image/png;base64,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">
<span style="font-size:18px"><strong>c</strong> = 0, <strong>d</strong> = 2</span>
<span style="font-size:18px"><strong>Output:</strong>
0
<strong>Explanation</strong>:
</span><img alt="" src="data:image/png;base64,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">
<span style="font-size:18px">blocking the edge between nodes 0 and 2
won't affect the connectivity of the graph.
So, it's not a Bridge Edge. All the Bridge
Edges in the graph are marked with a blue
line in the above image.</span>
</pre>

<p>&nbsp;</p>

<p><span style="font-size:18px"><strong>Your Task:</strong><br>
You don't need to read input or print anything. Your task is to complete the function&nbsp;<strong>isBridge()</strong>&nbsp;</span> <span style="font-size:18px">which takes number of vertices V<strong>, </strong>the number of edges&nbsp;E<strong>, </strong>an adjacency lsit adj and two integers c and d denoting the edge as input parameters&nbsp;and returns 1 if the given edge c-d is a Bridge<strong>.</strong>&nbsp;Else, it returns 0.</span></p>

<p>&nbsp;</p>

<p><span style="font-size:18px"><strong>Expected Time Complexity:</strong>&nbsp;O(V + E).<br>
<strong>Expected Auxiliary Space:</strong>&nbsp;O(V).</span></p>

<p>&nbsp;</p>

<p><span style="font-size:18px"><strong>Constraints:</strong><br>
1 </span> <span style="font-size:18px">≤</span> <span style="font-size:18px"> V,E </span> <span style="font-size:18px">≤</span> <span style="font-size:18px"> 10<sup>5</sup><br>
0 </span> <span style="font-size:18px">≤</span> <span style="font-size:18px"> c, d </span> <span style="font-size:18px">≤</span> <span style="font-size:18px"> V-1</span></p>
</div>